####### ------------------------------------------------------------------------
####### book title: "A crash course on macro-financial crises"
####### authors: Markus K. Brunnermeier and Ricardo Reis 
####### code: Figure 5.3
####### updated: 13/05/2021
####### code author: Liang Kaman / Rui Sousa
####### ------------------------------------------------------------------------


################################################################################
#
# INPUT YOUR DIRECTORY HERE (replace X with your directory):
direct <- "X" #<<<<----
#
################################################################################


############## Prepare
#clear environment
rm(list=ls()[ls()!="direct"])

#clear console
cat("\014")

#directory
setwd(direct)

#load and install libraries if needed
#load libraries to be used
packages <- c("zoo"
              ,"dplyr"
              ,"stringr" 
              ,"lubridate"
              ,"scales"
              ,"writexl"
              ,"readxl"
              ,"quantreg" #quantile regression
              ,"Hmisc"    #quantile estimation
)

#install them if needed be
new_packages <-
  packages[!(packages %in% installed.packages()[,"Package"])] 

if (length(new_packages)>0){ #installs them
  install.packages(new_packages, dependencies=TRUE)
}

#activate libraries
lapply(packages, require, character.only = TRUE)


############## Download & build data

#relevant banks for figure
banks3 <- c("il0a","a5g","birg")
banks3_names <- c("Irish Life & Perm","Allied Irish Banks","Bank of Ireland")

#read data from excel file
dfr <- read_excel("Fig. 5.3.xlsx", col_names = TRUE
                  , sheet = "data", range = "A1:G215")

#split columns
ret <- dfr[,!grepl("_p",colnames(dfr))]
w <- dfr[,grepl("date|_p",colnames(dfr))]
colnames(w)<- c("date",gsub("_p","",colnames(dfr)[grepl("_p",colnames(dfr))]))

#compute returns
ret[,-1] <- lapply(ret[,-1], function(x) x/lag(x)-1)

#remove first row lost
ret <- ret[-1,]

#compute weights
w <- w[,-1]/apply(w[,-1],1,sum)

#compute system's weighted returns
ret$system <- apply(ret[,-1]*w[-nrow(w),],1,sum)

############## Compute CoVaR

my_covar <- function(df,q,intercept=1){
  
  #eg: Var(95) = inf{K : P(X<K) >= 1-0.95 = 0.05}
  q <- 1 - q
  
  vars <- colnames(df)[!grepl("date|system",colnames(df))]
  
  #Use Harrell-Davis Distribution-Free Quantile Estimator
  #for quantiles
  
  #Computer VAR(qu)
  var <- unlist(lapply(df[,vars], quantile, probs = q))

  #Computer VAR(50) aka median
  median <- unlist(lapply(df[,vars], quantile, probs = 0.5))

  #Compute CoVar(qu) coefficients
  my_covar_coefs <- function(v, dfr = df, qu = q,intcpt = intercept) {
    if (intcpt==0) {
      form <- as.formula(paste0("system ~ ", v, " + 0"))
    } else if (intcpt==1) {
      form <- as.formula(paste0("system ~ ", v))
    }
    covar <- rq(form, qu, dfr)$coefficients
  }
  coefs <- unlist(lapply(vars, my_covar_coefs))
  
  #Compute deltaCoVaR(qu)
  k <- length(vars) 
  p <- length(coefs)/k
  
  coefs <- array(coefs, dim = c(p,k))
  coefs <- t(coefs)
  
  if (p == 1) {
    dcovar <- coefs[,ncol(coefs)]*(var-median)
  } else if (p == 2) {
    dcovar <- coefs[,1] + coefs[,2]*(var-median)
  }
  
  # #print
  print(var)
  print(median)
  print(coefs)
  print(dcovar)
  
  #turn to absolutes
  var <- abs(var); dcovar <- abs(dcovar)
  
  final_df <- data.frame(VaR = var, dCoVaR = dcovar)
  
  return(final_df)
  
}

#Delta CoVaR
qt = 0.95 
ret1995 <- ret[year(ret$date) >= 1995 
                &year(ret$date) <= 1997,]
ret2005 <- ret[year(ret$date) >= 2005 
                &year(ret$date) <= 2007,]

#results
results <- cbind(banks3_names,my_covar(ret1995, qt),my_covar(ret2005, qt))
colnames(results) <- c("bank"
                      ,paste0(colnames(results)[2:3],"(1995)")
                      ,paste0(colnames(results)[4:5],"(2005)"))

############## Export Results

write_xlsx(results, "figure5.3_data.xlsx.xlsx", col_names = TRUE)



